<?php
/*
Plugin Name: Sunriset
Plugin URI: http://jotrilide.free.fr/blog/?p=71
Description: Plugin qui fournit les dates de lever et coucher du Soleil
Author: jotrilide
Version: 1.0
Author URI: http://jotrilide.free.fr
*/
 
function sunriset($long,$lat,$offset) {
echo "Lever : " .date_sunrise(time(), SUNFUNCS_RET_STRING, $lat, $long, 90+16/60, $offset), "<br>" ;
echo "Coucher : " .date_sunset(time(), SUNFUNCS_RET_STRING,$lat,  $long, 90+16/60, $offset);
}
 
function init_sunriset(){
    register_widget_control('Sunriset', 'widget_sunriset_control');
    register_sidebar_widget('Sunriset', 'widget_sunriset'); 
}

function widget_sunriset($args) 
	  {
		  $options = get_option('widget_sunriset');
		  $title = empty($options['title']) ? __('Soleil à Paris') : $options['title'];
		  $long = empty($options['long']) ? __('2.348651') : $options['long'];
		  $lat = empty($options['lat']) ? __('48.853447') : $options['lat'];
		  $offset = empty($options['offset']) ? __('0') : $options['offset'];

		  extract($args);
		  echo $before_widget;
		  echo $before_title;
		  echo $title;
		  echo $after_title;
		  sunriset($long,$lat,$offset);
		  echo $after_widget;
	  }  
function widget_sunriset_control()
	  {
		$options = $newoptions = get_option('widget_sunriset');
		
		if ( $_POST['widget_sunriset-submit'] ) 
		{
			$newoptions['title'] = strip_tags(stripslashes($_POST['widget_sunriset-title']));
			$newoptions['long'] = strip_tags(stripslashes($_POST['widget_sunriset-long']));
			$newoptions['lat'] = strip_tags(stripslashes($_POST['widget_sunriset-lat']));
			$newoptions['offset'] = strip_tags(stripslashes($_POST['widget_sunriset-offset']));
		}
		if ( $options != $newoptions ) 
		{
			$options = $newoptions;
			update_option('widget_sunriset', $options);
		}
						
		$title = attribute_escape($options['title']);
		$long = attribute_escape($options['long']);
		$lat = attribute_escape($options['lat']);
		$offset = attribute_escape($options['offset']);

		echo '<p><label for="sunriset-title">';
		echo 'Titre: <input style="width: 250px;" id="widget_sunriset-title" name="widget_sunriset-title" type="text" value="';
		echo $title;
		echo '" />';
		echo '</label></p>';
		echo '<p><label for="sunriset-title">';
		echo 'Longitude (Est: + , Ouest: - ): <input style="width: 250px;" id="widget_sunriset-long" name="widget_sunriset-long" type="text" value="';
		echo $long;
		echo '" />';
		echo '</label></p>';
		echo '<p><label for="sunriset-title">';
		echo 'Latitude (Nord: + , Sud: - ) : <input style="width: 250px;" id="widget_sunriset-lat" name="widget_sunriset-lat" type="text" value="';
		echo $lat;
		echo '" />';
		echo '<p><label for="sunriset-title">';
		echo 'Fuseau horaire (UTC + ?) : <input style="width: 250px;" id="widget_sunriset-offset" name="widget_sunriset-offset" type="text" value="';
		echo $offset;
		echo '" />';
		echo '</label></p>';
		echo '<input type="hidden" id="widget_sunriset-submit" name="widget_sunriset-submit" value="1" />';
	  }
add_action("plugins_loaded", "init_sunriset");
?>